/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StaticFetch
extends Fetch {
    protected List<PyObject> results = new LinkedList<PyObject>();
    protected List<PyObject> descriptions = new LinkedList<PyObject>();

    public StaticFetch(DataHandler dataHandler) {
        super(dataHandler);
    }

    @Override
    public void add(ResultSet resultSet) {
        this.add(resultSet, null);
    }

    @Override
    public void add(ResultSet resultSet, Set<Integer> set) {
        try {
            if (resultSet != null && resultSet.getMetaData() != null) {
                PyObject pyObject = this.createDescription(resultSet.getMetaData());
                PyList pyList = this.createResults(resultSet, set, pyObject);
                this.results.add(pyList);
                this.descriptions.add(pyObject);
                this.rowcount = this.results.get(0).__len__();
                this.description = this.descriptions.get(0);
                this.rownumber = 0;
            }
        }
        catch (PyException pyException) {
            throw pyException;
        }
        catch (Throwable throwable) {
            throw zxJDBC.makeException(throwable);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void add(CallableStatement callableStatement, Procedure procedure, PyObject pyObject) {
        try {
            PyObject pyObject2 = this.createResults(callableStatement, procedure, pyObject);
            if (pyObject2.__len__() > 0) {
                this.results.add(pyObject2);
                this.descriptions.add(this.createDescription(procedure));
                this.rowcount = this.results.get(0).__len__();
                this.description = this.descriptions.get(0);
                this.rownumber = 0;
            }
        }
        catch (PyException pyException) {
            throw pyException;
        }
        catch (Throwable throwable) {
            throw zxJDBC.makeException(throwable);
        }
    }

    @Override
    public PyObject fetchall() {
        return this.fetchmany(this.rowcount);
    }

    @Override
    public PyObject fetchmany(int n) {
        if (this.results == null || this.results.size() == 0) {
            throw zxJDBC.makeException(zxJDBC.DatabaseError, "no results");
        }
        PyObject pyObject = new PyList();
        PyObject pyObject2 = this.results.get(0);
        if (n <= 0) {
            n = this.rowcount;
        }
        if (this.rownumber < this.rowcount) {
            pyObject = pyObject2.__getslice__(Py.newInteger(this.rownumber), Py.newInteger(this.rownumber + n), Py.One);
            this.rownumber += n;
        }
        return pyObject;
    }

    @Override
    public void scroll(int n, String string) {
        int n2;
        if ("relative".equals(string)) {
            n2 = this.rownumber + n;
        } else if ("absolute".equals(string)) {
            n2 = n;
        } else {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "invalid cursor scroll mode [" + string + "]");
        }
        if (n2 < 0 || n2 >= this.rowcount) {
            throw zxJDBC.makeException(Py.IndexError, "cursor index [" + n2 + "] out of range");
        }
        this.rownumber = n2;
    }

    @Override
    public PyObject nextset() {
        PyObject pyObject = Py.None;
        if (this.results != null && this.results.size() > 1) {
            this.results.remove(0);
            this.descriptions.remove(0);
            pyObject = this.results.get(0);
            this.description = this.descriptions.get(0);
            this.rowcount = pyObject.__len__();
            this.rownumber = 0;
        }
        return pyObject == Py.None ? Py.None : Py.One;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.rownumber = -1;
        this.results.clear();
    }
}

